<?php
require_once __DIR__ . '/../config/db.php';

try {
    // Check current payment_method column definition
    $stmt = $pdo->query("SHOW COLUMNS FROM credit_payments LIKE 'payment_method'");
    $columnInfo = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($columnInfo) {
        echo "Current payment_method column type: " . $columnInfo['Type'] . "\n";
        
        // If it's an ENUM, we need to modify it to include 'refund'
        if (strpos($columnInfo['Type'], 'enum') !== false) {
            // Extract current enum values
            preg_match("/enum\((.*)\)/", $columnInfo['Type'], $matches);
            $currentValues = $matches[1];
            
            // Add 'refund' to the enum values if it's not already there
            if (strpos($currentValues, "'refund'") === false) {
                $newValues = $currentValues . ",'refund'";
                $sql = "ALTER TABLE credit_payments MODIFY COLUMN payment_method ENUM($newValues)";
                echo "Executing SQL: $sql\n";
                $pdo->exec($sql);
                echo "Updated payment_method column to include 'refund'\n";
            } else {
                echo "'refund' is already in the payment_method enum values\n";
            }
        } else {
            // If it's not an ENUM, convert it to VARCHAR to allow any value
            $pdo->exec("ALTER TABLE credit_payments MODIFY COLUMN payment_method VARCHAR(50)");
            echo "Converted payment_method column to VARCHAR(50)\n";
        }
    } else {
        echo "payment_method column not found in credit_payments table\n";
    }
    
    echo "Migration completed successfully!\n";
    
} catch (PDOException $e) {
    echo "Error updating payment_method column: " . $e->getMessage() . "\n";
} 